* International Extension - What Caused the U.S Pandemic-Era Inflation? Bernanke, Blanchard 2023 
* This version : April 16, 2024
* Please contact Dilek Sevinc (dsevinc@piie.com) for further questions. 

* Subsample stability test (excl. JPN)
* USA, ECB, BOE, (JPN), FRA, GER, ESP, ITA, NLD, BEL, CAN

global basePath1 "/Users/dilek/Dropbox/Bernanke_Blanchard/international work/Code and Data/Replication Package/(1) Data"
global basePath2 "/Users/dilek/Dropbox/Bernanke_Blanchard/international work/Code and Data/Replication Package/(3) Regression Results"

***************************************************************************************************
* wage, constrained 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

********************************************************************************

putexcel set "Chow test", modify sheet("wage")
putexcel A1 = "Country"
putexcel B1 = "F test"
putexcel C1 = "degrees of freedom postcovid obs"
putexcel D1 = "degrees of freedom (precovid obs minus parameters)"
putexcel E1 = "critical value 10%"
putexcel F1 = "critical value 5%"
putexcel G1 = "critical value 1%"
putexcel H1 = "p-value"

****** Notes ************************************
* n   = pre-covid
* m   = post-covid
* n+m = full sample 
*************************************************

** USA ECB BOE FRA GER CAN

local teams "USA ECB BOE FRA GER CAN"
local startperiod_USA 1989
local startperiod_ECB 1989
local startperiod_BOE 1990
local startperiod_FRA 1989
local startperiod_GER 1996
local startperiod_CAN 1994

local row = 2
foreach c of local teams{

constraint define 1  l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' + l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' = 1

*n
cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' l1.magpty_`c' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), c(1)

predict gw_`c'_residuals_precovid if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), residuals
egen 	RSS_`c'_precovid = sum(gw_`c'_residuals_precovid^2)
di 		RSS_`c'_precovid

gen obs_`c'_precovid = e(N)
gen par_`c'_precovid = 17

*n+m
cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' l1.magpty_`c' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' dummyq2_2020 dummyq3_2020 if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), c(1)

predict gw_`c'_residuals_full if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), residuals
egen 	RSS_`c'_full = sum(gw_`c'_residuals_full^2)
di 		RSS_`c'_full

gen obs_`c'_full = e(N)
gen par_`c'_full = 19

gen obs_`c'_postcovid = obs_`c'_full - obs_`c'_precovid

gen df1_`c' = obs_`c'_postcovid  
gen df2_`c' = obs_`c'_precovid-par_`c'_full

gen F_`c' = ((RSS_`c'_full-RSS_`c'_precovid)/obs_`c'_postcovid)/(RSS_`c'_precovid/(obs_`c'_precovid-par_`c'_full))

gen crit_value_10_`c' = invFtail(df1_`c', df2_`c', 0.1)
gen crit_value_5_`c'  = invFtail(df1_`c', df2_`c', 0.05)
gen crit_value_1_`c'  = invFtail(df1_`c', df2_`c', 0.01)

di Ftail(df1_`c',df2_`c',F_`c')
gen ftail_`c' = Ftail(df1_`c',df2_`c',F_`c')

local ++row
putexcel A`row' = "`c'"
putexcel B`row' = F_`c'
putexcel C`row' = obs_`c'_postcovid
putexcel D`row' = obs_`c'_precovid-par_`c'_full
putexcel E`row' = crit_value_10_`c'
putexcel F`row' = crit_value_5_`c'
putexcel G`row' = crit_value_1_`c'
putexcel H`row' = ftail_`c'

	}


********************************************************************************
*** ESP ITA NLD

local teams "ESP ITA NLD"
local startperiod_ESP 1995
local startperiod_ITA 1999
local startperiod_NLD 1989

local m_ESP l1.magpty_ESP
local m_ITA magpty_ITA
local m_NLD l1.magpty_NLD

local row = 8
foreach c of local teams{

constraint define 1  l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' + l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' = 1

*n
cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' `m_`c'' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), c(1)

predict gw_`c'_residuals_precovid if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), residuals
egen 	RSS_`c'_precovid = sum(gw_`c'_residuals_precovid^2)
di 		RSS_`c'_precovid

gen obs_`c'_precovid = e(N)
gen par_`c'_precovid = 17

*n+m
cnsreg gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' `m_`c'' l1.vu_`c' l2.vu_`c' l3.vu_`c' l4.vu_`c' l1.diffcpicf_`c' l2.diffcpicf_`c' l3.diffcpicf_`c' l4.diffcpicf_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), c(1)

predict gw_`c'_residuals_full if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), residuals
egen 	RSS_`c'_full = sum(gw_`c'_residuals_full^2)
di 		RSS_`c'_full

gen obs_`c'_full = e(N)
gen par_`c'_full = 17

gen obs_`c'_postcovid = obs_`c'_full - obs_`c'_precovid

gen df1_`c' = obs_`c'_postcovid  
gen df2_`c' = obs_`c'_precovid-par_`c'_full

gen F_`c' = ((RSS_`c'_full-RSS_`c'_precovid)/obs_`c'_postcovid)/(RSS_`c'_precovid/(obs_`c'_precovid-par_`c'_full))

gen crit_value_10_`c' = invFtail(df1_`c', df2_`c', 0.1)
gen crit_value_5_`c'  = invFtail(df1_`c', df2_`c', 0.05)
gen crit_value_1_`c'  = invFtail(df1_`c', df2_`c', 0.01)

di Ftail(df1_`c',df2_`c',F_`c')
gen ftail_`c' = Ftail(df1_`c',df2_`c',F_`c')

local ++row
putexcel A`row' = "`c'"
putexcel B`row' = F_`c'
putexcel C`row' = obs_`c'_postcovid
putexcel D`row' = obs_`c'_precovid-par_`c'_full
putexcel E`row' = crit_value_10_`c'
putexcel F`row' = crit_value_5_`c'
putexcel G`row' = crit_value_1_`c'
putexcel H`row' = ftail_`c'

	}

	
	
********************************************************************************
** BEL 

constraint define 1  l1.gw_BEL + l2.gw_BEL + l3.gw_BEL + l4.gw_BEL + l1.cf1_BEL + l2.cf1_BEL + l3.cf1_BEL + l4.cf1_BEL = 1

*n
cnsreg gw_BEL l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL l1.magpty_BEL l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL ussc1_BEL c.dQ1_BEL#cL.diffcpicf_BEL if inrange(period, tq(1996:1),tq(2019:4)), c(1)

predict gw_residuals_BEL_precovid if inrange(period, tq(1996:1),tq(2019:4)), residuals
egen 	RSS_BEL_precovid = sum(gw_residuals_BEL_precovid^2)
di 		RSS_BEL_precovid

gen obs_BEL_precovid = e(N)
gen par_BEL_precovid = 17

*n+m
cnsreg gw_BEL l1.gw_BEL l2.gw_BEL l3.gw_BEL l4.gw_BEL l1.cf1_BEL l2.cf1_BEL l3.cf1_BEL l4.cf1_BEL l1.magpty_BEL l1.vu_BEL l2.vu_BEL l3.vu_BEL l4.vu_BEL l1.diffcpicf_BEL l2.diffcpicf_BEL l3.diffcpicf_BEL l4.diffcpicf_BEL ussc1_BEL c.dQ1_BEL#cL.diffcpicf_BEL if inrange(period, tq(1996:1),tq(2023:2)), c(1)

predict gw_residuals_BEL_full if inrange(period, tq(1996:1),tq(2023:2)), residuals
egen 	RSS_BEL_full = sum(gw_residuals_BEL_full^2)
di 		RSS_BEL_full

gen obs_BEL_full = e(N)
gen par_BEL_full = 19

gen obs_BEL_postcovid = obs_BEL_full - obs_BEL_precovid

gen df1_BEL = obs_BEL_postcovid  
gen df2_BEL = obs_BEL_precovid-par_BEL_full

gen F_BEL = ((RSS_BEL_full-RSS_BEL_precovid)/obs_BEL_postcovid)/(RSS_BEL_precovid/(obs_BEL_precovid-par_BEL_full))

gen crit_value_10_BEL = invFtail(df1_BEL, df2_BEL, 0.1)
gen crit_value_5_BEL  = invFtail(df1_BEL, df2_BEL, 0.05)
gen crit_value_1_BEL  = invFtail(df1_BEL, df2_BEL, 0.01)

di Ftail(df1_BEL,df2_BEL,F_BEL)
gen ftail_BEL = Ftail(df1_BEL,df2_BEL,F_BEL)

putexcel A12 = "BEL_social"
putexcel B12 = F_BEL
putexcel C12 = obs_BEL_postcovid
putexcel D12 = obs_BEL_precovid-par_BEL_full
putexcel E12 = crit_value_10_BEL
putexcel F12 = crit_value_5_BEL
putexcel G12 = crit_value_1_BEL
putexcel H12 = ftail_BEL



***************************************************************************************************
* price, constrained 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

**********************************************************************************

putexcel set "Chow test", modify sheet("price")
putexcel A1 = "Country"
putexcel B1 = "F test"
putexcel C1 = "degrees of freedom postcovid obs"
putexcel D1 = "degrees of freedom (precovid obs minus parameters)"
putexcel E1 = "critical value 10%"
putexcel F1 = "critical value 5%"
putexcel G1 = "critical value 1%"
putexcel H1 = "p-value"


****** Notes ************************************
* n   = pre-covid
* m   = post-covid
* n+m = full sample 
*************************************************

local teams "USA ECB BOE FRA GER CAN ESP ITA NLD BEL"
local startperiod_USA 1989
local startperiod_ECB 1989
local startperiod_BOE 1990
local startperiod_FRA 1989
local startperiod_GER 1996
local startperiod_ITA 1999
local startperiod_ESP 1995
local startperiod_BEL 1996
local startperiod_NLD 1989
local startperiod_CAN 1994

local row = 2
foreach c of local teams{

constraint define 2  l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' + gw_`c' + l1.gw_`c' + l2.gw_`c' + l3.gw_`c' + l4.gw_`c' = 1

*n
cnsreg gcpi_`c' magpty_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c' grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c' shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), c(2)

predict gcpi_`c'_residuals_precovid if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), residuals
egen 	RSS_`c'_precovid = sum(gcpi_`c'_residuals_precovid^2)
di 		RSS_`c'_precovid

gen obs_`c'_precovid = e(N)
gen par_`c'_precovid = 25

*n+m
cnsreg gcpi_`c' magpty_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' gw_`c' l1.gw_`c' l2.gw_`c' l3.gw_`c' l4.gw_`c' grpe_`c' l1.grpe_`c' l2.grpe_`c' l3.grpe_`c' l4.grpe_`c' grpf_`c' l1.grpf_`c' l2.grpf_`c' l3.grpf_`c' l4.grpf_`c' shortage_`c' l1.shortage_`c' l2.shortage_`c' l3.shortage_`c' l4.shortage_`c' if inrange(period, tq(1989:1),tq(2023:2)), c(2)

predict gcpi_`c'_residuals_full if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), residuals
egen 	RSS_`c'_full = sum(gcpi_`c'_residuals_full^2)
di 		RSS_`c'_full

gen obs_`c'_full = e(N)
gen par_`c'_full = 25

gen obs_`c'_postcovid = obs_`c'_full - obs_`c'_precovid

gen df1_`c' = obs_`c'_postcovid  
gen df2_`c' = obs_`c'_precovid-par_`c'_full

gen F_`c' = ((RSS_`c'_full-RSS_`c'_precovid)/obs_`c'_postcovid)/(RSS_`c'_precovid/(obs_`c'_precovid-par_`c'_full))

gen crit_value_10_`c' = invFtail(df1_`c', df2_`c', 0.1)
gen crit_value_5_`c'  = invFtail(df1_`c', df2_`c', 0.05)
gen crit_value_1_`c'  = invFtail(df1_`c', df2_`c', 0.01)

di Ftail(df1_`c',df2_`c',F_`c')
gen ftail_`c' = Ftail(df1_`c',df2_`c',F_`c')

local ++row
putexcel A`row' = "`c'"
putexcel B`row' = F_`c'
putexcel C`row' = obs_`c'_postcovid
putexcel D`row' = obs_`c'_precovid-par_`c'_full
putexcel E`row' = crit_value_10_`c'
putexcel F`row' = crit_value_5_`c'
putexcel G`row' = crit_value_1_`c'
putexcel H`row' = ftail_`c'

	}


***************************************************************************************************
* one year inflation expectation, constrained 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

**********************************************************************************

putexcel set "Chow test", modify sheet("cf1")
putexcel A1 = "Country"
putexcel B1 = "F test"
putexcel C1 = "degrees of freedom postcovid obs"
putexcel D1 = "degrees of freedom (precovid obs minus parameters)"
putexcel E1 = "critical value 10%"
putexcel F1 = "critical value 5%"
putexcel G1 = "critical value 1%"
putexcel H1 = "p-value"


****** Notes ************************************
* n   = pre-covid
* m   = post-covid
* n+m = full sample 
*************************************************

local teams "USA ECB BOE FRA GER CAN ESP ITA NLD BEL"
local startperiod_USA 1989
local startperiod_ECB 1989
local startperiod_BOE 1990
local startperiod_FRA 1989
local startperiod_GER 1996
local startperiod_ITA 1999
local startperiod_ESP 1995
local startperiod_BEL 1996
local startperiod_NLD 1989
local startperiod_CAN 1994

local row = 2
foreach c of local teams{
	
constraint define 3  l1.cf1_`c' + l2.cf1_`c' + l3.cf1_`c' + l4.cf1_`c' + cf10_`c' + l1.cf10_`c' + l2.cf10_`c' + l3.cf10_`c' + l4.cf10_`c' + gcpi_`c' + l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' = 1

* n
cnsreg cf1_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), c(3) noconstant

predict cf1_`c'_residuals_precovid if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), residuals
egen 	RSS_`c'_precovid = sum(cf1_`c'_residuals_precovid^2)
di 		RSS_`c'_precovid

gen obs_`c'_precovid = e(N)
gen par_`c'_precovid = 14

predict cf1f_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4))
gen cf1_residuals_`c' = cf1_`c'-cf1f_`c'

*n+m
cnsreg cf1_`c' l1.cf1_`c' l2.cf1_`c' l3.cf1_`c' l4.cf1_`c' cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), c(3) noconstant

predict cf1_`c'_residuals_full if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), residuals
egen 	RSS_`c'_full = sum(cf1_`c'_residuals_full^2)
di 		RSS_`c'_full

gen obs_`c'_full = e(N)
gen par_`c'_full = 14

gen obs_`c'_postcovid = obs_`c'_full - obs_`c'_precovid

gen df1_`c' = obs_`c'_postcovid  
gen df2_`c' = obs_`c'_precovid-par_`c'_full


gen F_`c' = ((RSS_`c'_full-RSS_`c'_precovid)/obs_`c'_postcovid)/(RSS_`c'_precovid/(obs_`c'_precovid-par_`c'_full))

gen crit_value_10_`c' = invFtail(df1_`c', df2_`c', 0.1)
gen crit_value_5_`c'  = invFtail(df1_`c', df2_`c', 0.05)
gen crit_value_1_`c'  = invFtail(df1_`c', df2_`c', 0.01)

di Ftail(df1_`c',df2_`c',F_`c')
gen ftail_`c' = Ftail(df1_`c',df2_`c',F_`c')

local ++row
putexcel A`row' = "`c'"
putexcel B`row' = F_`c'
putexcel C`row' = obs_`c'_postcovid
putexcel D`row' = obs_`c'_precovid-par_`c'_full
putexcel E`row' = crit_value_10_`c'
putexcel F`row' = crit_value_5_`c'
putexcel G`row' = crit_value_1_`c'
putexcel H`row' = ftail_`c'

	}
	

***************************************************************************************************
* ten year inflation expectation, constrained 
***************************************************************************************************
drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"

**********************************************************************************

putexcel set "Chow test", modify sheet("cf10")
putexcel A1 = "Country"
putexcel B1 = "F test"
putexcel C1 = "degrees of freedom postcovid obs"
putexcel D1 = "degrees of freedom (precovid obs minus parameters)"
putexcel E1 = "critical value 10%"
putexcel F1 = "critical value 5%"
putexcel G1 = "critical value 1%"
putexcel H1 = "p-value"


****** Notes ************************************
* n   = pre-covid
* m   = post-covid
* n+m = full sample 
*************************************************

local teams "USA ECB BOE FRA GER CAN ESP ITA NLD BEL"
local startperiod_USA 1989
local startperiod_ECB 1989
local startperiod_BOE 1990
local startperiod_FRA 1989
local startperiod_GER 1996
local startperiod_ITA 1999
local startperiod_ESP 1995
local startperiod_BEL 1996
local startperiod_NLD 1989
local startperiod_CAN 1994

local row = 2
foreach c of local teams{
	
constraint define 4 l1.cf10_`c' + l2.cf10_`c' + l3.cf10_`c' + l4.cf10_`c' + gcpi_`c' + l1.gcpi_`c' + l2.gcpi_`c' + l3.gcpi_`c' + l4.gcpi_`c' = 1

*n
cnsreg cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), c(4) noconstant


predict cf10_`c'_residuals_precovid if inrange(period, tq(`startperiod_`c'':1),tq(2019:4)), residuals
egen 	RSS_`c'_precovid = sum(cf10_`c'_residuals_precovid^2)
di 		RSS_`c'_precovid

gen obs_`c'_precovid = e(N)
gen par_`c'_precovid = 9

predict cf10f_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2019:4))
gen cf10_residuals_`c' = cf10_`c'-cf10f_`c'

*n+m
cnsreg cf10_`c' l1.cf10_`c' l2.cf10_`c' l3.cf10_`c' l4.cf10_`c' gcpi_`c' l1.gcpi_`c' l2.gcpi_`c' l3.gcpi_`c' l4.gcpi_`c' if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), c(4) noconstant

predict cf10_`c'_residuals_full if inrange(period, tq(`startperiod_`c'':1),tq(2023:2)), residuals
egen 	RSS_`c'_full = sum(cf10_`c'_residuals_full^2)
di 		RSS_`c'_full

gen obs_`c'_full = e(N)
gen par_`c'_full = 9

gen obs_`c'_postcovid = obs_`c'_full - obs_`c'_precovid

gen df1_`c' = obs_`c'_postcovid  
gen df2_`c' = obs_`c'_precovid-par_`c'_full


gen F_`c' = ((RSS_`c'_full-RSS_`c'_precovid)/obs_`c'_postcovid)/(RSS_`c'_precovid/(obs_`c'_precovid-par_`c'_full))

gen crit_value_10_`c' = invFtail(df1_`c', df2_`c', 0.1)
gen crit_value_5_`c'  = invFtail(df1_`c', df2_`c', 0.05)
gen crit_value_1_`c'  = invFtail(df1_`c', df2_`c', 0.01)

di Ftail(df1_`c',df2_`c',F_`c')
gen ftail_`c' = Ftail(df1_`c',df2_`c',F_`c')

local ++row
putexcel A`row' = "`c'"
putexcel B`row' = F_`c'
putexcel C`row' = obs_`c'_postcovid
putexcel D`row' = obs_`c'_precovid-par_`c'_full
putexcel E`row' = crit_value_10_`c'
putexcel F`row' = crit_value_5_`c'
putexcel G`row' = crit_value_1_`c'
putexcel H`row' = ftail_`c' 

	}




** CHOW TEST FOR GER 
***************************************************************************************************
* all four equations, constrained 
***************************************************************************************************

drop _all
clear matrix
clear mata   	
set more off	

cd "$basePath1"
use interm_all_clear, clear
cd "$basePath2"


****** Notes ************************************
* n   = pre-covid
* m   = post-covid
* n+m = full sample 
*************************************************


constraint define 1  [gw_GER]l1.gw_GER + [gw_GER]l2.gw_GER + [gw_GER]l3.gw_GER + [gw_GER]l4.gw_GER + [gw_GER]l1.cf1_GER + [gw_GER]l2.cf1_GER + [gw_GER]l3.cf1_GER + [gw_GER]l4.cf1_GER = 1

constraint define 2  [gcpi_GER]l1.gcpi_GER + [gcpi_GER]l2.gcpi_GER + [gcpi_GER]l3.gcpi_GER + [gcpi_GER]l4.gcpi_GER + [gcpi_GER]gw_GER + [gcpi_GER]l1.gw_GER + [gcpi_GER]l2.gw_GER + [gcpi_GER]l3.gw_GER + [gcpi_GER]l4.gw_GER = 1

constraint define 3  [cf1_GER]l1.cf1_GER + [cf1_GER]l2.cf1_GER + [cf1_GER]l3.cf1_GER + [cf1_GER]l4.cf1_GER + [cf1_GER]cf10_GER + [cf1_GER]l1.cf10_GER + [cf1_GER]l2.cf10_GER + [cf1_GER]l3.cf10_GER + [cf1_GER]l4.cf10_GER + [cf1_GER]gcpi_GER + [cf1_GER]l1.gcpi_GER + [cf1_GER]l2.gcpi_GER + [cf1_GER]l3.gcpi_GER + [cf1_GER]l4.gcpi_GER = 1.0

constraint define 4  [cf10_GER]l1.cf10_GER + [cf10_GER]l2.cf10_GER + [cf10_GER]l3.cf10_GER + [cf10_GER]l4.cf10_GER + [cf10_GER]gcpi_GER + [cf10_GER]l1.gcpi_GER + [cf10_GER]l2.gcpi_GER + [cf10_GER]l3.gcpi_GER + [cf10_GER]l4.gcpi_GER = 1.0


*n
reg3 (gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER l1.magpty_GER l1.vu_GER l2.vu_GER l3.vu_GER l4.vu_GER l1.diffcpicf_GER l2.diffcpicf_GER l3.diffcpicf_GER l4.diffcpicf_GER dummyq2_2020 dummyq3_2020) (gcpi_GER magpty_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER grpe_GER l1.grpe_GER l2.grpe_GER l3.grpe_GER l4.grpe_GER grpf_GER l1.grpf_GER l2.grpf_GER l3.grpf_GER l4.grpf_GER shortage_GER l1.shortage_GER l2.shortage_GER l3.shortage_GER l4.shortage_GER) (cf1_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER, noconstant) (cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER , noconstant) if tin(1996q1,2019q4), c(1 2 3 4) endog(gw_GER gcpi_GER cf1_GER cf10_GER diffcpicf_GER grpe_GER grpf_GER) exog(magpty_GER vu_GER shortage_GER) ols dfk

qui predict e_gw_GER_precovid   if tin(1996q1,2019q4),equation(gw_GER)   residuals
qui predict e_gcpi_GER_precovid if tin(1996q1,2019q4),equation(gcpi_GER) residuals
qui predict e_cf1_GER_precovid  if tin(1996q1,2019q4),equation(cf1_GER)  residuals
qui predict e_cf10_GER_precovid if tin(1996q1,2019q4),equation(cf10_GER) residuals

qui predict fit_gw_GER_precovid	  if tin(1996q1,2019q4),equation(gw_GER)   xb
qui predict fit_gcpi_GER_precovid if tin(1996q1,2019q4),equation(gcpi_GER) xb
qui predict fit_cf1_GER_precovid  if tin(1996q1,2019q4),equation(cf1_GER)  xb
qui predict fit_cf10_GER_precovid if tin(1996q1,2019q4),equation(cf10_GER) xb


egen RSS_gw_GER_precovid	= sum(e_gw_GER_precovid^2)
di RSS_gw_GER_precovid
egen RSS_gcpi_GER_precovid 	= sum(e_gcpi_GER_precovid^2)
di RSS_gcpi_GER_precovid
egen RSS_cf1_GER_precovid  	= sum(e_cf1_GER_precovid^2)
di RSS_cf1_GER_precovid
egen RSS_cf10_GER_precovid 	= sum(e_cf10_GER_precovid^2)
di RSS_cf10_GER_precovid

gen obs_GER_precovid = e(N)

gen par_gw_GER_precovid   = 17
gen par_gcpi_GER_precovid = 25
gen par_cf1_GER_precovid  = 14
gen par_cf10_GER_precovid = 9



*n+m
reg3 (gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER l1.magpty_GER l1.vu_GER l2.vu_GER l3.vu_GER l4.vu_GER l1.diffcpicf_GER l2.diffcpicf_GER l3.diffcpicf_GER l4.diffcpicf_GER dummyq2_2020 dummyq3_2020) (gcpi_GER magpty_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER gw_GER l1.gw_GER l2.gw_GER l3.gw_GER l4.gw_GER grpe_GER l1.grpe_GER l2.grpe_GER l3.grpe_GER l4.grpe_GER grpf_GER l1.grpf_GER l2.grpf_GER l3.grpf_GER l4.grpf_GER shortage_GER l1.shortage_GER l2.shortage_GER l3.shortage_GER l4.shortage_GER) (cf1_GER l1.cf1_GER l2.cf1_GER l3.cf1_GER l4.cf1_GER cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER, noconstant) (cf10_GER l1.cf10_GER l2.cf10_GER l3.cf10_GER l4.cf10_GER gcpi_GER l1.gcpi_GER l2.gcpi_GER l3.gcpi_GER l4.gcpi_GER , noconstant) if tin(1996q1,2023q2), c(1 2 3 4) endog(gw_GER gcpi_GER cf1_GER cf10_GER diffcpicf_GER grpe_GER grpf_GER) exog(magpty_GER vu_GER shortage_GER) ols dfk

qui predict e_gw_GER_full	if tin(1996q1,2023q2),equation(gw_GER)   residuals
qui predict e_gcpi_GER_full	if tin(1996q1,2023q2),equation(gcpi_GER) residuals
qui predict e_cf1_GER_full	if tin(1996q1,2023q2),equation(cf1_GER)  residuals
qui predict e_cf10_GER_full	if tin(1996q1,2023q2),equation(cf10_GER) residuals

qui predict fit_gw_GER_full	  if tin(1996q1,2023q2),equation(gw_GER)   xb
qui predict fit_gcpi_GER_full if tin(1996q1,2023q2),equation(gcpi_GER) xb
qui predict fit_cf1_GER_full  if tin(1996q1,2023q2),equation(cf1_GER)  xb
qui predict fit_cf10_GER_full if tin(1996q1,2023q2),equation(cf10_GER) xb


egen RSS_gw_GER_full	= sum(e_gw_GER_full^2)
di RSS_gw_GER_full
egen RSS_gcpi_GER_full 	= sum(e_gcpi_GER_full^2)
di RSS_gcpi_GER_full
egen RSS_cf1_GER_full  	= sum(e_cf1_GER_full^2)
di RSS_cf1_GER_full
egen RSS_cf10_GER_full 	= sum(e_cf10_GER_full^2)
di RSS_cf10_GER_full

gen obs_GER_full = e(N)

gen par_gw_GER_full	  = 19
gen par_gcpi_GER_full = 25
gen par_cf1_GER_full  = 14
gen par_cf10_GER_full = 9

gen obs_GER_postcovid = obs_GER_full - obs_GER_precovid

gen df1_GER = obs_GER_postcovid  

gen df2_gw_GER   = obs_GER_precovid-par_gw_GER_full
gen df2_gcpi_GER = obs_GER_precovid-par_gcpi_GER_full
gen df2_cf1_GER  = obs_GER_precovid-par_cf1_GER_full
gen df2_cf10_GER = obs_GER_precovid-par_cf10_GER_full


gen F_gw_GER 	= ((RSS_gw_GER_full-RSS_gw_GER_precovid)/obs_GER_postcovid)/(RSS_gw_GER_precovid/(obs_GER_precovid-par_gw_GER_full))
gen F_gcpi_GER 	= ((RSS_gcpi_GER_full-RSS_gcpi_GER_precovid)/obs_GER_postcovid)/(RSS_gcpi_GER_precovid/(obs_GER_precovid-par_gcpi_GER_full))
gen F_cf1_GER 	= ((RSS_cf1_GER_full-RSS_cf1_GER_precovid)/obs_GER_postcovid)/(RSS_cf1_GER_precovid/(obs_GER_precovid-par_cf1_GER_full))
gen F_cf10_GER 	= ((RSS_cf10_GER_full-RSS_cf10_GER_precovid)/obs_GER_postcovid)/(RSS_cf10_GER_precovid/(obs_GER_precovid-par_cf10_GER_full))


gen crit_value_10_gw_GER = invFtail(df1_GER, df2_gw_GER, 0.1)
gen crit_value_5_gw_GER  = invFtail(df1_GER, df2_gw_GER, 0.05)
gen crit_value_1_gw_GER  = invFtail(df1_GER, df2_gw_GER, 0.01)

gen crit_value_10_gcpi_GER = invFtail(df1_GER, df2_gcpi_GER, 0.1)
gen crit_value_5_gcpi_GER  = invFtail(df1_GER, df2_gcpi_GER, 0.05)
gen crit_value_1_gcpi_GER  = invFtail(df1_GER, df2_gcpi_GER, 0.01)

gen crit_value_10_cf1_GER = invFtail(df1_GER, df2_cf1_GER, 0.1)
gen crit_value_5_cf1_GER  = invFtail(df1_GER, df2_cf1_GER, 0.05)
gen crit_value_1_cf1_GER  = invFtail(df1_GER, df2_cf1_GER, 0.01)

gen crit_value_10_cf10_GER = invFtail(df1_GER, df2_cf10_GER, 0.1)
gen crit_value_5_cf10_GER  = invFtail(df1_GER, df2_cf10_GER, 0.05)
gen crit_value_1_cf10_GER  = invFtail(df1_GER, df2_cf10_GER, 0.01)



di Ftail(df1_GER, df2_gw_GER, F_gw_GER)
gen ftail_gw_GER = Ftail(df1_GER, df2_gw_GER, F_gw_GER)

di Ftail(df1_GER, df2_gcpi_GER, F_gcpi_GER)
gen ftail_gcpi_GER = Ftail(df1_GER, df2_gcpi_GER, F_gcpi_GER)

di Ftail(df1_GER, df2_cf1_GER, F_cf1_GER)
gen ftail_cf1_GER = Ftail(df1_GER, df2_cf1_GER, F_cf1_GER)

di Ftail(df1_GER, df2_cf10_GER, F_cf10_GER)
gen ftail_cf10_GER = Ftail(df1_GER, df2_cf10_GER, F_cf10_GER)


putexcel set "Chow test", modify sheet("wage")
putexcel A13 = "GER_reg3"
putexcel B13 = F_gw_GER
putexcel C13 = obs_GER_postcovid
putexcel D13 = obs_GER_precovid-par_gw_GER_full
putexcel E13 = crit_value_10_gw_GER
putexcel F13 = crit_value_5_gw_GER
putexcel G13 = crit_value_1_gw_GER
putexcel H13 = ftail_gw_GER

putexcel set "Chow test", modify sheet("price")
putexcel A13 = "GER_reg3"
putexcel B13 = F_gcpi_GER
putexcel C13 = obs_GER_postcovid
putexcel D13 = obs_GER_precovid-par_gcpi_GER_full
putexcel E13 = crit_value_10_gcpi_GER
putexcel F13 = crit_value_5_gcpi_GER
putexcel G13 = crit_value_1_gcpi_GER
putexcel H13 = ftail_gcpi_GER

putexcel set "Chow test", modify sheet("cf1")
putexcel A13 = "GER_reg3"
putexcel B13 = F_cf1_GER
putexcel C13 = obs_GER_postcovid
putexcel D13 = obs_GER_precovid-par_cf1_GER_full
putexcel E13 = crit_value_10_cf1_GER
putexcel F13 = crit_value_5_cf1_GER
putexcel G13 = crit_value_1_cf1_GER
putexcel H13 = ftail_cf1_GER

putexcel set "Chow test", modify sheet("cf10")
putexcel A13 = "GER_reg3"
putexcel B13 = F_cf10_GER
putexcel C13 = obs_GER_postcovid
putexcel D13 = obs_GER_precovid-par_cf10_GER_full
putexcel E13 = crit_value_10_cf10_GER
putexcel F13 = crit_value_5_cf10_GER
putexcel G13 = crit_value_1_cf10_GER
putexcel H13 = ftail_cf10_GER
